<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\SQLAdmin;

class PreCheckMajorVersionUpgradeContext extends \Google\Collection
{
  protected $collection_key = 'preCheckResponse';
  /**
   * @var string
   */
  public $kind;
  protected $preCheckResponseType = PreCheckResponse::class;
  protected $preCheckResponseDataType = 'array';
  /**
   * @var string
   */
  public $targetDatabaseVersion;

  /**
   * @param string
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * @param PreCheckResponse[]
   */
  public function setPreCheckResponse($preCheckResponse)
  {
    $this->preCheckResponse = $preCheckResponse;
  }
  /**
   * @return PreCheckResponse[]
   */
  public function getPreCheckResponse()
  {
    return $this->preCheckResponse;
  }
  /**
   * @param string
   */
  public function setTargetDatabaseVersion($targetDatabaseVersion)
  {
    $this->targetDatabaseVersion = $targetDatabaseVersion;
  }
  /**
   * @return string
   */
  public function getTargetDatabaseVersion()
  {
    return $this->targetDatabaseVersion;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(PreCheckMajorVersionUpgradeContext::class, 'Google_Service_SQLAdmin_PreCheckMajorVersionUpgradeContext');
